#pragma once
#include <iostream>
#include <cmath>
#include <vector>
#include "GException.h"

using namespace std;

//==========================================================
//  declaration of GVector
//==========================================================

class GVector
{

private:
	//members------------------------------------------------
	vector<double> _data;
	int _nbElements;

public:
	
	//inline Functions---------------------------------------
	inline void allocGVector();
	inline void desallocGVector();
	inline void getVector(const GVector& vect);
	
	//Constructors and destructors---------------------------
	GVector();
	GVector(int size);
	GVector(const GVector& vect);
	/*!
    *  \brief Destructor
    *
    *  Destroyer Class GVector
    */
	virtual ~GVector();

	//other methods------------------------------------------
	int size() const;
	double getNorm() const;
	void initWithValue(double v);
	
    //operators----------------------------------------------
	GVector& operator = (const GVector& vect);
	inline const double& operator() (const int &i) const{return _data[i-1];}
	inline double& operator() (const int &i){return _data[i-1];}
	GVector& operator += (const GVector& vect);
	GVector& operator -= (const GVector& vect);
    GVector& operator *= (const double& v);
	GVector operator - ();
	GVector operator + ();
	double operator ! ();
	friend GVector operator + (const GVector& vect1, const GVector& vect2);
	friend GVector operator - (const GVector& vect1, const GVector& vect2);
	friend double operator * (const GVector& vect1, const GVector& vect2);
	friend GVector operator * (const double& v, const GVector& vect);
	friend GVector operator * (const GVector& vect, const double& v);
	friend GVector operator / (const GVector& vect, const double& v);
	friend ostream& operator << (ostream& out, GVector vect);

};